/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.CEAVSB;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEAVendorSpecDataBlock
extends DataBlock {
    private ArrayList<CEAVSB> aVSBs;
    private static final int iVendorTag = 3;

    public CEAVendorSpecDataBlock() {
        super(31);
        this.iDataBlockTagCode = 3;
    }

    @Override
    public void removeDescriptor(int n) {
        this.aVSBs.remove(n);
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public void removeAllDescriptors() {
        this.aVSBs.clear();
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public boolean addDescriptor(CEADescriptor cEADescriptor) {
        boolean bl = false;
        if (this.aVSBs == null) {
            this.aVSBs = new ArrayList();
        }
        if (this.aVSBs.size() < this.iMaxNumberDescriptors) {
            this.aVSBs.add((CEAVSB)cEADescriptor);
            bl = true;
            this.adjustDescriptorLength_VendorSpecific(1, this.aVSBs.get(0).getDescriptorLength());
        } else {
            bl = false;
        }
        return bl;
    }

    public ArrayList<CEAVSB> getDescriptors() {
        return this.aVSBs;
    }

    public void clearDescriptors() {
        this.aVSBs.clear();
        this.aVSBs = null;
        this.adjustDescriptorLength_VendorSpecific(0, 0);
    }

    @Override
    public String getDataBlockName() {
        return DescriptorType.VENDOR_SPEC_DES.getBlockName();
    }

    @Override
    public String uploadDataBlockData(String string) {
        String string2 = null;
        super.setHeader(string.substring(0, 2));
        CEAVSB cEAVSB = new CEAVSB();
        cEAVSB.uploadDescriptorData(string.substring(2, string.length()));
        if (this.aVSBs == null) {
            this.aVSBs = new ArrayList(1);
            this.aVSBs.add(cEAVSB);
            this.adjustDescriptorLength_VendorSpecific(1, this.aVSBs.get(0).getDescriptorLength());
        } else {
            string2 = "ERROR: Max descriptors already reached!";
        }
        return string2;
    }

    @Override
    public String extractDataBlockData() {
        this.adjustDescriptorLength_VendorSpecific(this.getCurrentNumDescriptors(), this.aVSBs.get(0).getDescriptorLength());
        String string = new String();
        string = string.concat(super.getHeader());
        if (this.getCurrentNumDescriptors() >= 1) {
            string = string.concat(this.aVSBs.get(0).extractDescriptorData());
        }
        return string;
    }

    @Override
    public int getDataBlockChecksum() {
        String string = this.extractDataBlockData();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            n2 += Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return n2 & 0xFF;
    }
}

